/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.gsl.dango;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.grits.toolbox.ms.om.data.AnalyteSettings;
import org.grits.toolbox.ms.om.data.GlycanAnnotation;
import org.grits.toolbox.ms.om.data.GlycolipidAnnotation;
import org.grits.toolbox.ms.om.data.LipidAnnotation;
import org.grits.toolbox.ms.om.data.Method;
import org.grits.toolbox.tools.gsl.dango.GlycanAnnotationUtils;
import org.grits.toolbox.tools.gsl.dango.LipidAnnotationUtils;

public class GlycolipidAnnotationObjectProvider {
    private int m_nAnnotations;
    private List<GlycolipidAnnotation> m_lGLAnnotations;
    private List<GlycanAnnotation> m_lGAnnotations;
    private List<LipidAnnotation> m_lLAnnotations;

    public void clear() {
        this.m_nAnnotations = 0;
        this.m_lGLAnnotations = new ArrayList<GlycolipidAnnotation>();
        this.m_lGAnnotations = new ArrayList<GlycanAnnotation>();
        this.m_lLAnnotations = new ArrayList<LipidAnnotation>();
    }

    public List<GlycolipidAnnotation> getGlycolipidAnnotations() {
        return this.m_lGLAnnotations;
    }

    public List<GlycanAnnotation> getGlycanAnnotations() {
        return this.m_lGAnnotations;
    }

    public List<LipidAnnotation> getLipidAnnotations() {
        return this.m_lLAnnotations;
    }

    public void createAnnotations(Method a_method) {
        this.clear();
        HashMap<String, List<GlycanAnnotation>> t_mapURIToGAnnots = new HashMap<String, List<GlycanAnnotation>>();
        HashMap t_mapURIToLAnnots = new HashMap();
        ArrayList<String[]> t_lDBPairs = new ArrayList<String[]>();
        for (AnalyteSettings t_lAnalytes : a_method.getAnalyteSettings()) {
            String t_strGDBURI = null;
            if (t_lAnalytes.getGlycanSettings() != null && !t_mapURIToGAnnots.containsKey(t_strGDBURI = t_lAnalytes.getGlycanSettings().getFilter().getDatabase())) {
                t_mapURIToGAnnots.put(t_strGDBURI, new ArrayList());
                String t_strPerDerivType = t_lAnalytes.getGlycanSettings().getPerDerivatisationType();
                List<String[]> t_lGSeqIDs = GlycanAnnotationUtils.getGWBSequencesAndGlycanID(t_lAnalytes.getGlycanSettings());
                if (!t_lGSeqIDs.isEmpty()) {
                    for (String[] t_GSeqID : t_lGSeqIDs) {
                        GlycanAnnotation t_gAnnot = this.getGlycanAnnotation(t_GSeqID[0], t_GSeqID[1], t_strPerDerivType);
                        this.modifyGlycanStringID(t_mapURIToGAnnots, t_strGDBURI, t_gAnnot);
                        ((List)t_mapURIToGAnnots.get(t_strGDBURI)).add(t_gAnnot);
                    }
                }
            }
            String t_strLDBURI = null;
            if (t_lAnalytes.getLipidSettings() != null && !t_mapURIToLAnnots.containsKey(t_strLDBURI = t_lAnalytes.getLipidSettings().getDatabase().getURI())) {
                t_mapURIToLAnnots.put(t_strLDBURI, new ArrayList());
                String t_strPerDerivType = t_lAnalytes.getLipidSettings().getPerDerivatisationType();
                List<String> t_lLNames = LipidAnnotationUtils.getLipidNames(t_lAnalytes.getLipidSettings());
                if (!t_lLNames.isEmpty()) {
                    for (String t_strLName : t_lLNames) {
                        LipidAnnotation t_lAnnot = this.getLipidAnnotation(t_strLName, t_strPerDerivType);
                        ((List)t_mapURIToLAnnots.get(t_strLDBURI)).add(t_lAnnot);
                    }
                }
            }
            String[] t_strDBPair = new String[]{t_strGDBURI, t_strLDBURI};
            t_lDBPairs.add(t_strDBPair);
        }
        for (String[] t_strDBPair : t_lDBPairs) {
            if (t_strDBPair[0] != null && t_strDBPair[1] != null) {
                for (GlycanAnnotation t_gAnnot : (List)t_mapURIToGAnnots.get(t_strDBPair[0])) {
                    for (LipidAnnotation t_lAnnot : (List)t_mapURIToLAnnots.get(t_strDBPair[1])) {
                        this.m_lGLAnnotations.add(this.getGlycolipidAnnotation(t_gAnnot, t_lAnnot));
                    }
                }
                continue;
            }
            if (t_strDBPair[0] != null) {
                this.m_lGAnnotations.addAll((Collection)t_mapURIToGAnnots.get(t_strDBPair[0]));
                continue;
            }
            if (t_strDBPair[1] == null) continue;
            this.m_lLAnnotations.addAll((Collection)t_mapURIToLAnnots.get(t_strDBPair[1]));
        }
    }

    private GlycolipidAnnotation getGlycolipidAnnotation(GlycanAnnotation a_gAnnot, LipidAnnotation a_lAnnot) {
        GlycolipidAnnotation t_glAnnot = new GlycolipidAnnotation();
        t_glAnnot.setId(Integer.valueOf(++this.m_nAnnotations));
        String t_strGLSeq = a_gAnnot.getSequence().replace(",freeEnd", "," + a_lAnnot.getSequence() + "=0.0000u");
        t_glAnnot.setSequence(t_strGLSeq);
        t_glAnnot.setStringId(String.valueOf(a_gAnnot.getStringId()) + "--" + a_lAnnot.getStringId());
        t_glAnnot.setGlycanAnnotation(a_gAnnot);
        t_glAnnot.setLipidAnnotation(a_lAnnot);
        t_glAnnot.setPerDerivatisationType(a_gAnnot.getPerDerivatisationType());
        return t_glAnnot;
    }

    private GlycanAnnotation getGlycanAnnotation(String a_strGSeq, String a_strGID, String a_strPerDeriv) {
        GlycanAnnotation t_gAnnot = new GlycanAnnotation();
        t_gAnnot.setId(Integer.valueOf(++this.m_nAnnotations));
        t_gAnnot.setStringId(a_strGID);
        t_gAnnot.setSequence(a_strGSeq);
        t_gAnnot.setSequenceGWB(a_strGSeq);
        t_gAnnot.setPerDerivatisationType(a_strPerDeriv);
        return t_gAnnot;
    }

    private LipidAnnotation getLipidAnnotation(String a_strLName, String a_strPerDeriv) {
        LipidAnnotation t_lAnnot = new LipidAnnotation();
        t_lAnnot.setId(Integer.valueOf(++this.m_nAnnotations));
        String t_strComposition = LipidAnnotationUtils.getLipidComposition(a_strLName);
        if (!t_strComposition.isEmpty()) {
            t_lAnnot.setComposition(t_strComposition);
        }
        t_lAnnot.setSequence(a_strLName);
        t_lAnnot.setStringId(a_strLName);
        t_lAnnot.setPerDerivatisationType(a_strPerDeriv);
        return t_lAnnot;
    }

    private void modifyGlycanStringID(Map<String, List<GlycanAnnotation>> a_mapURIToGAnnots, String a_strURI, GlycanAnnotation a_gAnnot) {
        boolean t_bDuplicated = false;
        for (String t_strURI : a_mapURIToGAnnots.keySet()) {
            if (t_strURI.equals(a_strURI)) continue;
            String t_strDBName = new File(t_strURI).getName().replace(".xml", "");
            t_strDBName = "(DB:" + t_strDBName + ")";
            for (GlycanAnnotation t_gAnnot : a_mapURIToGAnnots.get(t_strURI)) {
                String t_strGStringID = t_gAnnot.getStringId();
                if (t_strGStringID.contains(t_strDBName)) {
                    t_strGStringID = t_strGStringID.replace(t_strDBName, "");
                }
                if (!t_strGStringID.equals(a_gAnnot.getStringId())) continue;
                t_gAnnot.setStringId(String.valueOf(t_strDBName) + t_strGStringID);
                t_bDuplicated = true;
            }
        }
        if (t_bDuplicated) {
            String t_strDBName = new File(a_strURI).getName().replace(".xml", "");
            t_strDBName = "(DB:" + t_strDBName + ")";
            a_gAnnot.setStringId(String.valueOf(t_strDBName) + a_gAnnot.getStringId());
        }
    }
}

