/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.gsl.wizard.lipidgeneration;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.tools.gsl.wizard.lipidgeneration.LipidGenerationSettingPage;

public class DataEntryPage
extends WizardPage {
    private static final Logger logger = Logger.getLogger(LipidGenerationSettingPage.class);
    private Text m_textTitle;
    private Text m_textFileName;
    private StyledText m_textDescription;
    private Text m_textVersion;
    private Text m_textCreatorName;
    private Text m_textCreatorInstitution;

    public DataEntryPage() {
        super("Lipid Database Generation");
        this.setTitle("Lipid Database Generation");
        this.setDescription("Generate lipid database for identifying lipids in Glycosphingolipid.");
    }

    public String getDatabaseTitle() {
        return this.m_textTitle.getText().trim();
    }

    public String getOutputFileName() {
        return this.m_textFileName.getText().trim();
    }

    public String getDatabaseDescription() {
        return this.m_textDescription.getText().trim();
    }

    public String getVersion() {
        return this.m_textVersion.getText().trim();
    }

    public String getCreatorName() {
        return this.m_textCreatorName.getText().trim();
    }

    public String getCreatorInstitution() {
        return this.m_textCreatorInstitution.getText().trim();
    }

    public void createControl(final Composite parent) {
        logger.debug((Object)"BEGIN DataEntryPage");
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(3, false));
        Label lblOutputFileName = new Label(container, 0);
        lblOutputFileName.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblOutputFileName.setText("Output File Name");
        this.m_textFileName = new Text(container, 2048);
        this.m_textFileName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Button btnBrowse = new Button(container, 0);
        btnBrowse.setText("Browse");
        GridData gdButton = new GridData(131072, 128, false, false, 1, 1);
        gdButton.widthHint = 100;
        btnBrowse.setLayoutData((Object)gdButton);
        btnBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog dlgSave = new FileDialog(parent.getShell(), 8192);
                dlgSave.setFilterNames(new String[]{"XML database (*.xml)", "All files (*.*)"});
                dlgSave.setFilterExtensions(new String[]{"*.xml", "*.*"});
                dlgSave.setOverwrite(true);
                dlgSave.open();
                String strFilePath = dlgSave.getFilterPath();
                String strFileName = dlgSave.getFileName();
                if (strFileName.length() == 0 || strFilePath == null) {
                    return;
                }
                strFileName = String.valueOf(strFilePath) + File.separator + strFileName;
                DataEntryPage.this.m_textFileName.setText(strFileName);
            }
        });
        Label lblLipidDatabaseName = new Label(container, 0);
        lblLipidDatabaseName.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblLipidDatabaseName.setText("Lipid Database Title");
        this.m_textTitle = this.makeText(container);
        Label lblDescription = new Label(container, 0);
        lblDescription.setText("Description");
        new Label(container, 0);
        new Label(container, 0);
        this.m_textDescription = new StyledText(container, 2048);
        this.m_textDescription.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        Label lblVersion = new Label(container, 0);
        lblVersion.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblVersion.setText("Version");
        this.m_textVersion = this.makeText(container);
        this.m_textVersion.setText("1.0");
        Label lblContributerName = new Label(container, 0);
        lblContributerName.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblContributerName.setText("Creator Name");
        this.m_textCreatorName = this.makeText(container);
        Label lblContributerInstitution = new Label(container, 0);
        lblContributerInstitution.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblContributerInstitution.setText("Creator Institution");
        this.m_textCreatorInstitution = this.makeText(container);
        this.setPageComplete(false);
        HashMap<Text, String> t_mapRequiredTextToErrorMessage = new HashMap<Text, String>();
        t_mapRequiredTextToErrorMessage.put(this.m_textFileName, "File name is required.");
        t_mapRequiredTextToErrorMessage.put(this.m_textTitle, "Database title is required.");
        t_mapRequiredTextToErrorMessage.put(this.m_textVersion, "Version is required.");
        this.setRequieredTexts(t_mapRequiredTextToErrorMessage);
        logger.debug((Object)"END DataEntryPage");
    }

    private Text makeText(Composite cmp) {
        Text txt = new Text(cmp, 2048);
        txt.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        return txt;
    }

    private void setRequieredTexts(final Map<Text, String> a_mapRequiredTextToErrorMessage) {
        for (Text t_textRequired : a_mapRequiredTextToErrorMessage.keySet()) {
            t_textRequired.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    for (Text t_textRequiredMod : a_mapRequiredTextToErrorMessage.keySet()) {
                        if (!t_textRequiredMod.getText().trim().isEmpty()) continue;
                        DataEntryPage.this.setErrorMessage((String)a_mapRequiredTextToErrorMessage.get(t_textRequiredMod));
                        DataEntryPage.this.setPageComplete(false);
                        return;
                    }
                    DataEntryPage.this.setErrorMessage(null);
                    DataEntryPage.this.setPageComplete(true);
                }
            });
            t_textRequired.addListener(31, new Listener(){

                public void handleEvent(Event event) {
                    for (Text t_textRequiredMod : a_mapRequiredTextToErrorMessage.keySet()) {
                        if (!t_textRequiredMod.getText().trim().isEmpty()) continue;
                        DataEntryPage.this.setErrorMessage((String)a_mapRequiredTextToErrorMessage.get(t_textRequiredMod));
                        DataEntryPage.this.setPageComplete(false);
                        return;
                    }
                    DataEntryPage.this.setErrorMessage(null);
                    DataEntryPage.this.setPageComplete(true);
                }
            });
        }
    }
}

