/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.resourcesdb.atom;

import java.util.ArrayList;
import java.util.List;
import org.eurocarbdb.resourcesdb.ResourcesDbException;
import org.eurocarbdb.resourcesdb.atom.AtomConnection;
import org.eurocarbdb.resourcesdb.atom.AtomTemplate;
import org.eurocarbdb.resourcesdb.atom.Isotope;
import org.eurocarbdb.resourcesdb.atom.Mol2Type;
import org.eurocarbdb.resourcesdb.atom.Periodic;
import org.eurocarbdb.resourcesdb.util.NumberUtils;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Atom
implements Cloneable {
    private int id = 0;
    private int dbId = 0;
    private AtomTemplate template = null;
    private Periodic element = null;
    private Isotope isotope = null;
    private String name = null;
    private String mol2Type = null;
    private Double charge = null;
    private List<AtomConnection> connectionList = null;
    private boolean deletedInLinkage = false;
    private Double x = null;
    private Double y = null;
    private Double z = null;

    public Atom() {
        this.init();
    }

    public Atom(Periodic el) {
        this.init();
        this.setElement(el);
    }

    public Atom(String elSym) throws ResourcesDbException {
        this.init();
        this.setElement(Periodic.getElementBySymbol(elSym));
    }

    public Atom(AtomTemplate tmpl) {
        this.init();
        this.setTemplate(tmpl);
        this.setElement(tmpl.getElement());
        this.setMol2Type(tmpl.getMol2Type());
    }

    public Atom(int id, Periodic el, String name) {
        this.init();
        this.setId(id);
        this.setElement(el);
        this.setName(name);
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public AtomTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(AtomTemplate tmpl) {
        this.template = tmpl;
    }

    public void setTemplateAndInit(AtomTemplate tmpl) {
        this.template = tmpl;
        this.setElement(tmpl.getElement());
        this.setName(tmpl.getElement().getSymbol());
        this.setMol2Type(tmpl.getMol2Type());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getMol2Type() {
        if (this.mol2Type == null) {
            this.setMol2Type(Mol2Type.getMol2Type(this));
        }
        return this.mol2Type;
    }

    public void setMol2Type(String type) {
        this.mol2Type = type;
    }

    public Periodic getElement() {
        return this.element;
    }

    public void setElement(Periodic element) {
        this.element = element;
    }

    public String getElementSymbol() {
        if (this.getElement() == null) {
            return null;
        }
        return this.getElement().getSymbol();
    }

    public void setElementSymbol(String symbol) throws ResourcesDbException {
        this.setElement(Periodic.getElementBySymbol(symbol));
    }

    public Double getCharge() {
        return this.charge;
    }

    public double getChargeValue() {
        if (this.getCharge() == null) {
            return 0.0;
        }
        return this.getCharge();
    }

    public void setCharge(Double charge) {
        this.charge = charge;
    }

    public void setCharge(double charge) {
        this.charge = new Double(charge);
    }

    public List<AtomConnection> getConnections() {
        return this.connectionList;
    }

    public void setConnections(List<AtomConnection> connections) {
        this.connectionList = connections;
    }

    public void addConnection(Atom to, double bo) {
        if (!this.hasConnection(to)) {
            this.addConnection(new AtomConnection(this, to, bo));
        }
        if (!to.hasConnection(this)) {
            to.addConnection(this, bo);
        }
    }

    public void addConnection(AtomConnection conect) {
        this.getConnections().add(conect);
    }

    public boolean removeConnection(Atom to) {
        for (AtomConnection ac : this.getConnections()) {
            if (ac.getToAtom() != to) continue;
            this.getConnections().remove(ac);
            return true;
        }
        return false;
    }

    public boolean hasConnection(Atom to) {
        for (AtomConnection ac : this.getConnections()) {
            if (!ac.getToAtom().equals(to)) continue;
            return true;
        }
        return false;
    }

    public List<AtomConnection> getConnectionsClone() {
        ArrayList<AtomConnection> retList = new ArrayList<AtomConnection>();
        for (AtomConnection ac : this.getConnections()) {
            retList.add(ac.clone());
        }
        return retList;
    }

    public Isotope getIsotope() {
        return this.isotope;
    }

    public void setIsotope(Isotope iso) {
        this.isotope = iso;
    }

    public int getDbId() {
        return this.dbId;
    }

    public void setDbId(int dbId) {
        this.dbId = dbId;
    }

    public boolean isDeletedInLinkage() {
        return this.deletedInLinkage;
    }

    public void setDeletedInLinkage(boolean flag) {
        this.deletedInLinkage = flag;
    }

    public Double getX() {
        return this.x;
    }

    public void setX(Double xD) {
        this.x = xD;
    }

    public Double getY() {
        return this.y;
    }

    public void setY(Double yD) {
        this.y = yD;
    }

    public Double getZ() {
        return this.z;
    }

    public void setZ(Double zD) {
        this.z = zD;
    }

    public void setCoordinates(Double xD, Double yD, Double zD) {
        this.setX(xD);
        this.setY(yD);
        this.setZ(zD);
    }

    public double getBondSum() {
        double bs = 0.0;
        for (AtomConnection ac : this.getConnections()) {
            bs += ac.getBondOrder().doubleValue();
        }
        return bs;
    }

    public int countBonds() {
        if (this.getConnections() == null) {
            return 0;
        }
        return this.getConnections().size();
    }

    public int countBondsByBondorder(double bo) {
        int count = 0;
        if (this.getConnections() != null) {
            for (AtomConnection con : this.getConnections()) {
                if (con.getBondOrder() != bo) continue;
                ++count;
            }
        }
        return count;
    }

    public int countSingleBonds() {
        return this.countBondsByBondorder(1.0);
    }

    public int countDoubleBonds() {
        return this.countBondsByBondorder(2.0);
    }

    public int countAromaticBonds() {
        return this.countBondsByBondorder(1.5);
    }

    public int countTripleBonds() {
        return this.countBondsByBondorder(3.0);
    }

    public Atom getConnectedAtom(String elemSymbol, int index) {
        if (this.getConnections() != null) {
            int count = 0;
            for (AtomConnection acon : this.getConnections()) {
                Atom toAtom = acon.getToAtom();
                if (toAtom.equals(this)) {
                    toAtom = acon.getFromAtom();
                }
                if (toAtom.getElementSymbol() == null || !toAtom.getElementSymbol().equals(elemSymbol) || ++count != index) continue;
                return toAtom;
            }
        }
        return null;
    }

    public int countConnectedAtoms(String elemSymbol) {
        int count = 0;
        if (this.getConnections() != null) {
            for (AtomConnection acon : this.getConnections()) {
                Atom toAtom = acon.getToAtom();
                if (toAtom.equals(this)) {
                    toAtom = acon.getFromAtom();
                }
                if (toAtom.getElementSymbol() == null || !toAtom.getElementSymbol().equals(elemSymbol)) continue;
                ++count;
            }
        }
        return count;
    }

    public static Atom parseXmlAtomTag(Element atomtag) throws ResourcesDbException {
        Atom a = null;
        if (atomtag.getName().equalsIgnoreCase("atom")) {
            a = new Atom();
            a.setId(Integer.parseInt(atomtag.getAttributeValue("id")));
            a.setName(atomtag.getAttributeValue("name"));
            a.setElement(Periodic.getElementBySymbol(atomtag.getAttributeValue("element")));
            a.setX(NumberUtils.parseDoubleStr(atomtag.getAttributeValue("x"), null));
            a.setY(NumberUtils.parseDoubleStr(atomtag.getAttributeValue("y"), null));
            a.setZ(NumberUtils.parseDoubleStr(atomtag.getAttributeValue("z"), null));
        }
        return a;
    }

    public void init() {
        this.setId(0);
        this.setDbId(0);
        this.setName(null);
        this.setElement(null);
        this.setIsotope(null);
        this.setCharge(null);
        this.setConnections(new ArrayList<AtomConnection>());
    }

    public boolean equals(Object o) {
        Atom a;
        return o instanceof Atom && ((a = (Atom)o).getName() == null && this.getName() == null || a.getName() != null && a.getName().equals(this.getName())) && (a.getElement() == null && this.getElement() == null || a.getElement() != null && a.getElement().equals((Object)this.getElement())) && (a.getIsotope() == null && this.getIsotope() == null || a.getIsotope() != null && a.getIsotope().equals(this.getIsotope()));
    }

    public String toString() {
        String outStr = "Atom [Id: " + this.getId() + " Element: " + this.getElement().getSymbol() + " Name: " + this.getName() + " Charge: " + this.getCharge();
        if (this.isDeletedInLinkage()) {
            outStr = outStr + " (deleted)";
        }
        outStr = outStr + "]";
        return outStr;
    }

    public Atom clone() {
        Atom a = new Atom(this.getElement());
        a.setName(this.getName());
        a.setIsotope(this.getIsotope());
        a.setCharge(this.getCharge());
        a.setConnections(this.getConnectionsClone());
        a.setTemplate(this.getTemplate());
        a.setMol2Type(this.getMol2Type());
        a.setX(this.getX());
        a.setY(this.getY());
        a.setZ(this.getZ());
        return a;
    }

    public static void removeAtomFromList(List<Atom> atomList, Atom a, boolean removeHydrogens) {
        Atom aClone = null;
        for (Atom listAtom : atomList) {
            if (!listAtom.equals(a)) continue;
            aClone = listAtom;
            break;
        }
        atomList.remove(aClone);
        for (AtomConnection con : aClone.getConnections()) {
            Atom toAtom = null;
            toAtom = con.getToAtom().equals(aClone) ? con.getFromAtom() : con.getToAtom();
            if (removeHydrogens && toAtom.getElementSymbol().equals("H")) {
                atomList.remove(con.getToAtom());
                continue;
            }
            ArrayList<AtomConnection> removeCons = new ArrayList<AtomConnection>();
            for (AtomConnection backCon : toAtom.getConnections()) {
                if (!backCon.getToAtom().equals(aClone)) continue;
                removeCons.add(backCon);
            }
            for (AtomConnection remCon : removeCons) {
                toAtom.getConnections().remove(remCon);
            }
        }
    }

    public static void printAtoms(List<Atom> atomList) {
        for (Atom a : atomList) {
            System.out.println(a.toString());
            for (AtomConnection con : a.getConnections()) {
                System.out.println("   " + con.toString());
            }
        }
    }
}

