/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.resourcesdb.io;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.eurocarbdb.resourcesdb.ResourcesDbException;
import org.eurocarbdb.resourcesdb.atom.Atom;
import org.eurocarbdb.resourcesdb.atom.AtomConnection;
import org.eurocarbdb.resourcesdb.monosaccharide.Monosaccharide;
import org.eurocarbdb.resourcesdb.util.NumberUtils;

public class Mol2Exporter {
    private static void writeHeader(Monosaccharide ms, PrintStream printer) throws IOException {
        printer.println("# Monosaccharide " + ms.getName());
        printer.println("# generated by MonosaccharideDB");
        printer.println();
        printer.println("@<TRIPOS>MOLECULE");
        printer.println(ms.getName());
        printer.println(ms.getAtoms().size());
        printer.println("SACCHARIDE");
        printer.println("NO_CHARGES");
        printer.println();
        printer.println();
    }

    private static void writeAtoms(Monosaccharide ms, PrintStream printer) throws IOException {
        printer.println("@<TRIPOS>ATOM");
        int atomIndex = 0;
        for (Atom a : ms.getAtoms()) {
            a.setId(++atomIndex);
            String atomLine = a.getId() + " " + a.getName();
            atomLine = atomLine + " " + NumberUtils.nullsaveDoubleValue(a.getX()) + " " + NumberUtils.nullsaveDoubleValue(a.getY()) + " " + NumberUtils.nullsaveDoubleValue(a.getZ());
            atomLine = atomLine + " " + a.getMol2Type();
            printer.println(atomLine);
        }
    }

    private static void writeBonds(Monosaccharide ms, PrintStream printer) throws IOException {
        printer.println("@<TRIPOS>BOND");
        for (Atom a : ms.getAtoms()) {
            int bondIndex = 0;
            for (AtomConnection aCon : a.getConnections()) {
                int toId = aCon.getToAtom().getId();
                if (toId == a.getId()) {
                    toId = aCon.getFromAtom().getId();
                }
                if (a.getId() >= toId) continue;
                String boStr = aCon.getBondOrder() == 1.0 ? "1" : (aCon.getBondOrder() == 1.5 ? "ar" : (aCon.getBondOrder() == 2.0 ? "2" : (aCon.getBondOrder() == 3.0 ? "3" : "un")));
                String bondLine = ++bondIndex + " " + a.getId() + " " + toId + " " + boStr;
                printer.println(bondLine);
            }
        }
    }

    public static void export(Monosaccharide ms, FileOutputStream fOut) throws ResourcesDbException {
        if (fOut == null) {
            throw new ResourcesDbException("File output stream is null in mol2exporter.");
        }
        if (ms == null) {
            throw new ResourcesDbException("Monosaccharide is null in mol2exporter.");
        }
        try {
            PrintStream printer = new PrintStream(fOut);
            Mol2Exporter.writeHeader(ms, printer);
            Mol2Exporter.writeAtoms(ms, printer);
            Mol2Exporter.writeBonds(ms, printer);
        }
        catch (IOException ioEx) {
            ResourcesDbException rEx = new ResourcesDbException("IO exception in mol2exporter");
            rEx.initCause(ioEx);
            throw rEx;
        }
    }

    public static void export(Monosaccharide ms, String fileName) throws ResourcesDbException {
        FileOutputStream fOut;
        try {
            fOut = new FileOutputStream(fileName);
        }
        catch (Exception ex) {
            ResourcesDbException rEx = new ResourcesDbException("Cannot initialize FileOutputStream for file name '" + fileName + "'");
            rEx.initCause(ex);
            throw rEx;
        }
        Mol2Exporter.export(ms, fOut);
        try {
            fOut.close();
        }
        catch (Exception ex) {
            ResourcesDbException rEx = new ResourcesDbException("Cannot close FileOutputStream for file name '" + fileName + "'");
            rEx.initCause(ex);
            throw rEx;
        }
    }
}

