/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.resourcesdb.util;

import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum NumberPrefix {
    DI(2, "di"),
    BIS(2, "bis"),
    TRI(3, "tri"),
    TETRA(4, "tetra"),
    PENTA(5, "penta"),
    HEXA(6, "hexa"),
    HEPTA(7, "hepta"),
    OCTA(8, "octa"),
    NONA(9, "nona"),
    DECA(10, "deca"),
    UNDECA(11, "undeca"),
    DODECA(12, "dodeca");

    private String prefixStr;
    private int size;

    private NumberPrefix(int theSize, String prefix) {
        this.setSize(theSize);
        this.setPrefixStr(prefix);
    }

    public String getPrefixStr() {
        return this.prefixStr;
    }

    private void setPrefixStr(String prefix) {
        this.prefixStr = prefix;
    }

    public int getSize() {
        return this.size;
    }

    private void setSize(int theSize) {
        this.size = theSize;
    }

    public static NumberPrefix forName(String nameStr) {
        for (NumberPrefix prefix : NumberPrefix.values()) {
            if (prefix.name().equalsIgnoreCase(nameStr)) {
                return prefix;
            }
            if (!prefix.getPrefixStr().equalsIgnoreCase(nameStr)) continue;
            return prefix;
        }
        return null;
    }

    public static NumberPrefix forSize(int theSize) {
        for (NumberPrefix prefix : NumberPrefix.values()) {
            if (prefix.getSize() != theSize) continue;
            return prefix;
        }
        return null;
    }

    public static ArrayList<NumberPrefix> getPrefixListBySize(int theSize) {
        ArrayList<NumberPrefix> outlist = new ArrayList<NumberPrefix>();
        for (NumberPrefix prefix : NumberPrefix.values()) {
            if (prefix.getSize() != theSize) continue;
            outlist.add(prefix);
        }
        return outlist;
    }
}

