/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.gsl.util.generator.structure;

import java.util.ArrayList;
import java.util.List;
import org.grits.toolbox.tools.gsl.structure.LipidFragmentInfo;
import org.grits.toolbox.tools.gsl.structure.lipid.Ceramide;
import org.grits.toolbox.tools.gsl.structure.lipid.FattyAcid;
import org.grits.toolbox.tools.gsl.structure.lipid.ILipid;
import org.grits.toolbox.tools.gsl.structure.lipid.Lipid;
import org.grits.toolbox.tools.gsl.structure.lipid.Sphingomyelin;
import org.grits.toolbox.tools.gsl.structure.lipid.Sphingosine;

public class LipidFragmenter {
    private int m_nH2OLossLimit = -1;

    public void setWaterLossLimit(int a_nLimit) {
        this.m_nH2OLossLimit = a_nLimit;
    }

    public List<LipidFragmentInfo> fragment(ILipid a_iLip) {
        if (this.m_nH2OLossLimit < 0) {
            this.m_nH2OLossLimit = a_iLip.getNumberOfHydroxylGroups();
        }
        if (a_iLip instanceof Sphingomyelin) {
            return this.generateFragments((Sphingomyelin)a_iLip, this.m_nH2OLossLimit);
        }
        if (a_iLip instanceof Ceramide) {
            return this.generateFragments((Ceramide)a_iLip, this.m_nH2OLossLimit);
        }
        if (a_iLip instanceof Sphingosine) {
            return this.generateFragments((Sphingosine)a_iLip, this.m_nH2OLossLimit);
        }
        if (a_iLip instanceof Lipid) {
            return this.generateFragments((Lipid)a_iLip, this.m_nH2OLossLimit);
        }
        return null;
    }

    private List<LipidFragmentInfo> generateFragments(Sphingomyelin a_sm, int a_nLimit) {
        ArrayList<LipidFragmentInfo> t_listFragments = new ArrayList<LipidFragmentInfo>();
        LipidFragmentInfo t_fragInfoOrig = new LipidFragmentInfo(a_sm);
        t_listFragments.add(t_fragInfoOrig);
        Sphingosine t_sp = a_sm.getSphingosine();
        t_sp = new Sphingosine(t_sp.getCarbonLength(), t_sp.getNumberOfHydroxylGroups() - 1, t_sp.getNumberOfOAcetylGroups(), t_sp.getNumberOfUnsaturation() + 1);
        Ceramide t_cer = new Ceramide(t_sp, a_sm.getFattyAcid());
        for (LipidFragmentInfo t_fragInfo : this.generateFragments(t_cer, a_nLimit)) {
            t_fragInfo.addFragmentType("PC", 1);
            t_listFragments.add(t_fragInfo);
        }
        return t_listFragments;
    }

    private List<LipidFragmentInfo> generateFragments(Ceramide a_cer, int a_nLimit) {
        ArrayList<LipidFragmentInfo> t_listFragments = new ArrayList<LipidFragmentInfo>();
        LipidFragmentInfo t_fragInfoOrig = new LipidFragmentInfo(a_cer);
        t_listFragments.add(t_fragInfoOrig);
        Sphingosine t_sp = a_cer.getSphingosine();
        FattyAcid t_fa = a_cer.getFattyAcid();
        int t_nCSp = t_sp.getCarbonLength();
        int t_nOHSp = t_sp.getNumberOfHydroxylGroups();
        int t_nOAcSp = t_sp.getNumberOfOAcetylGroups();
        int t_nDBSp = t_sp.getNumberOfUnsaturation();
        int t_nCFA = t_fa.getCarbonLength();
        int t_nOHFA = t_fa.getNumberOfHydroxylGroups();
        int t_nOAcFA = t_fa.getNumberOfOAcetylGroups();
        int t_nDBFA = t_fa.getNumberOfUnsaturation();
        int i = 1;
        while (i <= a_nLimit) {
            if (i > t_nOHSp + t_nOHFA) break;
            int j = 0;
            while (j <= i) {
                int k = i - j;
                if (j <= t_nOHSp && k <= t_nOHFA) {
                    Sphingosine t_spFragment = new Sphingosine(t_nCSp, t_nOHSp - j, t_nOAcSp, t_nDBSp + j);
                    FattyAcid t_faFragment = new FattyAcid(t_nCFA, t_nOHFA - k, t_nOAcFA, t_nDBFA + k);
                    LipidFragmentInfo t_fragInfo = new LipidFragmentInfo(new Ceramide(t_spFragment, t_faFragment));
                    t_fragInfo.addFragmentType("H2O", i);
                    t_listFragments.add(t_fragInfo);
                }
                ++j;
            }
            ++i;
        }
        for (LipidFragmentInfo t_fragInfo : this.generateFragments(t_sp, a_nLimit)) {
            t_fragInfo.addFragmentType("FA", 1);
            t_listFragments.add(t_fragInfo);
        }
        Lipid t_lipFAFrag = new Lipid(0, 0, 1, t_nCFA, t_nOHFA, t_nOAcFA, t_nDBFA);
        for (LipidFragmentInfo t_fragInfo : this.generateFragments(t_lipFAFrag, a_nLimit)) {
            t_fragInfo.addFragmentType("Sp", 1);
            t_listFragments.add(t_fragInfo);
        }
        return t_listFragments;
    }

    private List<LipidFragmentInfo> generateFragments(Lipid a_lip, int a_nLimit) {
        ArrayList<LipidFragmentInfo> t_listFragments = new ArrayList<LipidFragmentInfo>();
        LipidFragmentInfo t_fragInfoOrig = new LipidFragmentInfo(a_lip);
        t_listFragments.add(t_fragInfoOrig);
        int t_nNH2 = a_lip.getNumberOfAmine();
        int t_nCOOH = a_lip.getNumberOfCarboxyl();
        int t_nCONH2 = a_lip.getNumberOfCarbamoyl();
        int t_nC = a_lip.getCarbonLength();
        int t_nOH = a_lip.getNumberOfHydroxylGroups();
        int t_nOAc = a_lip.getNumberOfOAcetylGroups();
        int t_nDB = a_lip.getNumberOfUnsaturation();
        int i = 1;
        while (i <= t_nOH) {
            if (i <= a_nLimit && i <= t_nOH) {
                Lipid t_lip = new Lipid(t_nCOOH, t_nNH2, t_nCONH2, t_nC, t_nOH - i, t_nOAc, t_nDB + i);
                if (t_nNH2 == 1 && t_nCOOH == 0 && t_nCONH2 == 0) {
                    t_lip = new Sphingosine(t_nC, t_nOH - i, t_nOAc, t_nDB + i);
                }
                if (t_nNH2 == 0 && t_nCOOH == 1 && t_nCONH2 == 0) {
                    t_lip = new FattyAcid(t_nC, t_nOH - i, t_nOAc, t_nDB + i);
                }
                LipidFragmentInfo t_fragInfo = new LipidFragmentInfo(t_lip);
                t_fragInfo.addFragmentType("H2O", i);
                t_listFragments.add(t_fragInfo);
            }
            ++i;
        }
        return t_listFragments;
    }
}

