/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.gsl.util.io.excel;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.poi.ss.examples.AddDimensionedImage;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Picture;
import org.apache.poi.ss.usermodel.Sheet;

public class ExcelWriterHelper
extends AddDimensionedImage {
    public void writeCellImage(Sheet a_sheet, int a_iRowNum, int a_iColNum, BufferedImage a_img, List<Picture> a_imgs) throws Exception {
        if (a_iColNum < 0 || a_img == null) {
            return;
        }
        Drawing drawing = a_sheet.createDrawingPatriarch();
        double imageWidthMM = AddDimensionedImage.ConvertImageUnits.widthUnits2Millimetres(AddDimensionedImage.ConvertImageUnits.pixel2WidthUnits(a_img.getWidth()));
        double imageHeightMM = AddDimensionedImage.ConvertImageUnits.widthUnits2Millimetres(AddDimensionedImage.ConvertImageUnits.pixel2WidthUnits(a_img.getHeight()));
        AddDimensionedImage.ClientAnchorDetail colClientAnchorDetail = this.fitImageToColumns(a_sheet, a_iColNum, imageWidthMM, 3);
        AddDimensionedImage.ClientAnchorDetail rowClientAnchorDetail = this.fitImageToRows(a_sheet, a_iRowNum, imageHeightMM, 3);
        ClientAnchor anchor = a_sheet.getWorkbook().getCreationHelper().createClientAnchor();
        anchor.setDx1(0);
        anchor.setDy1(0);
        anchor.setDx2(colClientAnchorDetail.getInset());
        anchor.setDy2(rowClientAnchorDetail.getInset());
        anchor.setCol1(colClientAnchorDetail.getFromIndex());
        anchor.setRow1(rowClientAnchorDetail.getFromIndex());
        anchor.setCol2(colClientAnchorDetail.getToIndex());
        anchor.setRow2(rowClientAnchorDetail.getToIndex());
        anchor.setAnchorType(ClientAnchor.AnchorType.MOVE_AND_RESIZE);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)a_img, "png", bos);
        int index = a_sheet.getWorkbook().addPicture(bos.toByteArray(), 6);
        a_imgs.add(drawing.createPicture(anchor, index));
    }
}

