/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.sample.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.grits.toolbox.entry.sample.model.Component;

@XmlRootElement(name="sample")
@XmlType(propOrder={"name", "description", "version", "components"})
public class Sample {
    public static final String CURRENT_VERSION = "1.0";
    private String name = null;
    private String description = null;
    private Double version = null;
    private List<Component> components = new ArrayList<Component>();

    public Sample() {
        this.version = Double.valueOf(CURRENT_VERSION);
    }

    @XmlAttribute(name="name", required=true)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlElement(name="description", required=false)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @XmlAttribute(name="version", required=true)
    public Double getVersion() {
        return this.version;
    }

    public void setVersion(Double version) {
        this.version = version;
    }

    @XmlElement(name="component")
    public List<Component> getComponents() {
        return this.components;
    }

    public void setComponents(List<Component> components) {
        this.components = components;
    }

    public void addComponent(Component comp) {
        this.components.add(comp);
    }

    public Integer getNextAvailableComponentId() {
        Integer lastMaxId = 0;
        for (Component comp : this.components) {
            if (comp.getComponentId() == null || comp.getComponentId() <= lastMaxId) continue;
            lastMaxId = comp.getComponentId();
        }
        return lastMaxId + 1;
    }

    public Set<String> getAllComponentLabels() {
        HashSet<String> allLabels = new HashSet<String>();
        for (Component component : this.components) {
            allLabels.add(component.getLabel());
        }
        return allLabels;
    }
}

