/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.sample.part.editsupport;

import com.hp.hpl.jena.vocabulary.XSD;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.trie.PatriciaTrie;
import org.apache.log4j.Logger;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.core.typeahead.NamespaceHandler;
import org.grits.toolbox.core.typeahead.PatriciaTrieContentProposalProvider;
import org.grits.toolbox.core.utilShare.CalendarCellEditor;
import org.grits.toolbox.core.utilShare.validator.DoubleValidator;
import org.grits.toolbox.entry.sample.model.Descriptor;
import org.grits.toolbox.entry.sample.model.Namespace;
import org.grits.toolbox.entry.sample.utilities.TextCellEditorWithContentProposal;

public class EditingSupportForValue
extends EditingSupport {
    private Logger logger = Logger.getLogger(EditingSupportForValue.class);
    private CellEditor textCellEditor = null;
    private CellEditor doubleCellEditor = null;
    private CalendarCellEditor calendarCellEditor = null;
    private SimpleDateFormat simpleDateFormat1 = new SimpleDateFormat("MM/dd/yyyy");
    private SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");
    private MDirtyable dirtyable = null;

    public EditingSupportForValue(TreeViewer treeViewer, MDirtyable dirtyable) {
        super((ColumnViewer)treeViewer);
        this.init((Composite)treeViewer.getTree());
        this.dirtyable = dirtyable;
    }

    public EditingSupportForValue(TableViewer tableViewer) {
        super((ColumnViewer)tableViewer);
        this.init((Composite)tableViewer.getTable());
    }

    private void init(Composite comp) {
        this.textCellEditor = new TextCellEditor(comp);
        this.doubleCellEditor = new TextCellEditor(comp);
        ((Text)this.doubleCellEditor.getControl()).setTextLimit(80);
        ControlDecoration doubleControlDecoration = new ControlDecoration(this.doubleCellEditor.getControl(), 0x1000000);
        this.doubleCellEditor.setValidator((ICellEditorValidator)new DoubleValidator(doubleControlDecoration));
        this.calendarCellEditor = new CalendarCellEditor(comp);
    }

    protected void setValue(Object element, Object value) {
        if (element instanceof Descriptor) {
            Descriptor descriptor = (Descriptor)element;
            String stringValue = value == null ? "" : value.toString();
            stringValue = stringValue.trim();
            stringValue = value instanceof Date ? this.simpleDateFormat1.format(value) : stringValue;
            String string = stringValue = stringValue.isEmpty() ? null : stringValue;
            if (!Objects.equals(stringValue, descriptor.getValue())) {
                descriptor.setValue(stringValue);
                ColumnViewer viewer = this.getViewer();
                viewer.refresh((Object)descriptor);
                if (this.dirtyable != null) {
                    this.dirtyable.setDirty(true);
                }
            }
        }
    }

    protected Object getValue(Object element) {
        String value = "";
        if (element instanceof Descriptor) {
            Descriptor descriptor = (Descriptor)element;
            if (this.getCellEditor(descriptor) instanceof CalendarCellEditor) {
                return this.parseDateValue(descriptor.getValue());
            }
            value = descriptor.getValue() == null ? value : descriptor.getValue();
        }
        return value;
    }

    private Date parseDateValue(String value) {
        Date date = null;
        if (value != null && !value.isEmpty()) {
            try {
                date = this.simpleDateFormat1.parse(value);
            }
            catch (ParseException parseException) {
                try {
                    date = this.simpleDateFormat2.parse(value);
                }
                catch (ParseException parseException2) {
                    this.logger.error((Object)("date could not be parsed : " + value));
                }
            }
        }
        return date;
    }

    protected CellEditor getCellEditor(Object element) {
        Descriptor descriptor;
        List<Namespace> namespaces;
        Iterator<Namespace> iterator;
        if (element instanceof Descriptor && (iterator = (namespaces = (descriptor = (Descriptor)element).getNamespaces()).iterator()).hasNext()) {
            Namespace namespace = iterator.next();
            if (namespace.getNamespaceFile() != null) {
                try {
                    NamespaceHandler handler = new NamespaceHandler(namespace.getUri(), null, namespace.getNamespaceFile(), "org.grits.toolbox.entry.sample");
                    PatriciaTrie trie = handler.getTrieForNamespace();
                    if (trie != null) {
                        PatriciaTrieContentProposalProvider contentProposalProvider = new PatriciaTrieContentProposalProvider(trie);
                        ColumnViewer viewer = this.getViewer();
                        if (viewer != null) {
                            return new TextCellEditorWithContentProposal((Composite)viewer.getControl(), (IContentProposalProvider)contentProposalProvider, null, null);
                        }
                    }
                }
                catch (Exception ex) {
                    this.logger.error((Object)ex.getMessage(), (Throwable)ex);
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Type Ahead Error", (String)("Something went wrong for the namespace " + namespace.getLabel() + ".Typeahead is not available!"));
                    return this.textCellEditor;
                }
            }
            if (namespace.getUri().equals(XSD.xdouble.getURI())) {
                return this.doubleCellEditor;
            }
            if (namespace.getUri().equals(XSD.date.getURI())) {
                return this.calendarCellEditor;
            }
            if (namespace.getUri().equals(XSD.xstring.getURI())) {
                return this.textCellEditor;
            }
            return null;
        }
        return null;
    }

    protected boolean canEdit(Object element) {
        boolean editable = false;
        if (element instanceof Descriptor) {
            List<Namespace> namespaces = ((Descriptor)element).getNamespaces();
            for (Namespace namespace : namespaces) {
                if (!namespace.getUri().equals(XSD.xstring.getURI()) && !namespace.getUri().equals(XSD.xboolean.getURI()) && !namespace.getUri().equals(XSD.xdouble.getURI()) && !namespace.getUri().equals(XSD.date.getURI()) && namespace.getNamespaceFile() == null) continue;
                editable = true;
                break;
            }
        }
        return editable;
    }
}

